/***************************************************************************
 *   IrregularVerb is a GNOME Applet which helps you to learn english irregular verbs
 *   Copyright (C) 2009 by Renaud Guezennec   *
 *   http://renaudguezennec.homelinux.org/accueil,3.html   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <panel-applet.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <libintl.h>
#include <locale.h>
#include <stdio.h>
#include <stdlib.h>



/*Define*/
#define NUMBER_LINES 179
#define SIZE_LINE 300
#define SIZE_MENU 500

typedef struct
{
	GtkWidget *label;
        GtkWidget *boite;
        GIOChannel* from;
        gchar* str_return;
        GTimeVal temps;
        GDate date;
        guint doy;
        guint i;
       PanelApplet* applet;
}verbs;

static gchar* file = NULL;
/*Function of the update*/
static void IrregularVerb_applet_properties_dialog (BonoboUIComponent *uic,gpointer _myverbs,const char *cname) 
{

	guint i =0;

	verbs *myverbs=(verbs *)_myverbs;
 	g_get_current_time(&(*myverbs).temps);
	g_date_set_time_val(&(myverbs->date),&(myverbs->temps));
	myverbs->doy=g_date_get_day_of_year(&(myverbs->date));
	myverbs->doy=myverbs->doy%NUMBER_LINES;
	file = g_malloc( 1024 );
	sprintf(file,"/usr/share/IrregularVerbs/data");

    if(myverbs->from!=NULL)
    {	
    	myverbs->from= g_io_channel_new_file(file,"r",NULL);
		
            while((g_io_channel_read_line(myverbs->from,&(myverbs->str_return),NULL,NULL,NULL)==G_IO_STATUS_NORMAL)&&(i!=myverbs->doy))
                {
                   i++;
                }
			
			int i = 0;
			while(i<SIZE_LINE)
			{
				if(myverbs->str_return[i] == '\t')
				{
					myverbs->str_return[i]=' ';
				}
				else if(myverbs->str_return[i] == '\n')
				{
				myverbs->str_return[i]='\0';
					i = SIZE_LINE;
				}
				i++;
			}




			gtk_label_set_label(GTK_LABEL(myverbs->label),myverbs->str_return);
    	  
   			//gtk_container_add (GTK_CONTAINER (myverbs->applet), myverbs->label);

			gtk_widget_show_all (GTK_WIDGET (myverbs->applet));


	}
	
}
/*Menu*/



static BonoboUIVerb IrregularVerb_menu_verbs [] = {
	        BONOBO_UI_VERB ("IrregularVerbProperties",IrregularVerb_applet_properties_dialog),
	        BONOBO_UI_VERB_END
	};
/*Frist init*/	
static gboolean
IrregularVerb_applet_fill (PanelApplet *applet,
   const gchar *iid,
   gpointer data)
{
	


	guint i=0;
	verbs* myverbs=g_malloc(sizeof(verbs));

	myverbs->str_return=NULL;


	setlocale( LC_ALL, "" );
bindtextdomain( "IV", "/usr/share/locale" );
textdomain( "IV" );

char* Context_menu_xml = malloc(SIZE_MENU);

sprintf(Context_menu_xml,"<popup name=\"button3\">\n"
	   "   <menuitem name=\"Properties Item\" "
	   "             verb=\"IrregularVerbProperties\" "
	   "           _label=\"%s\"\n"
	   "          pixtype=\"stock\" "
	   "          pixname=\"gtk-refresh\"/>\n"
	   "</popup>\n",gettext("_update"));

	if (strcmp (iid, "OAFIID:irregularverbs") != 0)
		return FALSE;

	myverbs->str_return =g_malloc(SIZE_LINE);
	file = g_malloc( 1024 );

	sprintf(file,"/usr/share/IrregularVerbs/data");
	
	if(g_file_test(file, G_FILE_TEST_EXISTS))
	{
 
		myverbs->from= g_io_channel_new_file(file,"r",NULL);
		g_get_current_time(&(myverbs->temps));
		myverbs->applet=applet;
		g_date_set_time_val(&(myverbs->date),&(myverbs->temps));
	 	myverbs->doy=g_date_get_day_of_year(&(myverbs->date));
		myverbs->doy=myverbs->doy%NUMBER_LINES;
 	

		if(myverbs->from!=NULL)
		{

			while((g_io_channel_read_line(myverbs->from,&(myverbs->str_return),NULL,NULL,NULL)==G_IO_STATUS_NORMAL)&&(i!=myverbs->doy))
			{
  
				i++;
			}

			int i = 0;
			while(i<SIZE_LINE)/*Remove \t and \n of the data line*/	
			{
				if(myverbs->str_return[i] == '\t')
				{
					myverbs->str_return[i]=' ';
				}
				else if(myverbs->str_return[i] == '\n')
				{
					myverbs->str_return[i]='\0';
					i = SIZE_LINE;
				}
				i++;
			}



		//	printf("%s",Context_menu_xml);
		//sprintf(Context_menu_xml,Context_menu_xml,gettext("_Mise à jour"));



		myverbs->label = gtk_label_new (myverbs->str_return);
	
		panel_applet_setup_menu (PANEL_APPLET (applet),
		                 Context_menu_xml,
		                 IrregularVerb_menu_verbs,
			              myverbs);

		gtk_container_add (GTK_CONTAINER (applet), myverbs->label);

		gtk_widget_show_all (GTK_WIDGET (applet));

		}
	}
	
	return TRUE;
}

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:irregularverbs_Factory",
                             PANEL_TYPE_APPLET,
                             "Irregularverbs Applet",
                             "0",
                             IrregularVerb_applet_fill,
                             NULL);
